/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.animationdp.test;

import filenet.sim.animationdp.IVWSIMAnimationDP;
import filenet.sim.animationdp.IVWSIMEvent;
import filenet.sim.animationdp.impl2.VWSIMAnimationDP;
import filenet.sim.api.VWScenarioDefinition;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.rmi.Naming;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import simulator.ISimulator;
import simulator.scenario.BasicScenario;

public class AutoTest
extends Thread {
    private int m_order = 0;
    private static ISimulator m_simEngine = null;
    private static Object synchObj = new Object();
    private static String m_simEngineURL = null;
    private static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.S");
    private String m_scenarioFile = null;
    private String m_outDir = null;
    private BasicScenario m_scenarioInfo = null;
    private String m_desc = null;
    private boolean retrieveIt = false;
    private boolean saveIt = false;
    private boolean reportIt = false;
    private boolean analyzeIt = false;
    private String m_serviceName = null;
    private int m_region = 0;
    private VWScenarioDefinition m_scenarioDefinition = null;
    private IVWSIMAnimationDP m_animationDP = null;

    public static ArrayList getFiles(String dir) throws Exception {
        File thisDir = new File(dir);
        File[] contents = thisDir.listFiles();
        ArrayList<File> res = null;
        if (contents != null) {
            int size = contents.length;
            while (--size >= 0) {
                File f = contents[size];
                if (!f.isFile()) continue;
                if (res == null) {
                    res = new ArrayList<File>(size);
                }
                res.add(f.getCanonicalFile());
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getSimEngine(String server, String serverPort) throws Exception {
        Object object = synchObj;
        synchronized (object) {
            if (m_simEngine == null) {
                m_simEngineURL = "rmi://" + server + ":" + serverPort + "/WorkflowSimulator";
                AutoTest.gReport("Looking up Sim Engine at " + m_simEngineURL);
                m_simEngine = (ISimulator)Naming.lookup(m_simEngineURL);
            }
        }
    }

    private void report(String s) {
        System.out.println(dateFormatter.format(new Date()) + "\t" + this.m_desc + ":\t" + s);
    }

    public static void gReport(String s) {
        System.out.println(dateFormatter.format(new Date()) + "\t" + s);
    }

    public AutoTest(int order, String fileName, String outDir, boolean retrieveIt, boolean reportIt, boolean saveIt, boolean analyzeIt) {
        super(Integer.toString(order) + ":" + fileName);
        this.m_order = order;
        this.m_desc = "File [" + Integer.toString(order) + "] " + fileName;
        this.m_scenarioFile = fileName;
        this.m_outDir = outDir;
        this.retrieveIt = retrieveIt;
        this.reportIt = reportIt;
        this.saveIt = saveIt;
        this.analyzeIt = analyzeIt;
    }

    public AutoTest(int order, BasicScenario scenarioInfo, String outDir, boolean retrieveIt, boolean reportIt, boolean saveIt, boolean analyzeIt) {
        super(Integer.toString(order) + ":" + scenarioInfo.name);
        this.m_desc = "Simulation [" + Integer.toString(order) + "] " + scenarioInfo.name;
        this.m_scenarioInfo = scenarioInfo;
        this.m_outDir = outDir;
        this.retrieveIt = retrieveIt;
        this.reportIt = reportIt;
        this.saveIt = saveIt;
        this.analyzeIt = analyzeIt;
    }

    private void validateFile() throws Exception {
        if (this.m_scenarioFile == null) {
            throw new Exception("No scenario file was given.");
        }
        this.m_scenarioDefinition = VWScenarioDefinition.readFromFile(this.m_scenarioFile);
        this.m_serviceName = this.m_scenarioDefinition.getConfiguration().getServiceName();
        this.m_region = this.m_scenarioDefinition.getConfiguration().getIsolatedRegion();
        this.report("validateFile OK, serviceName=" + this.m_serviceName + ", ir=" + Integer.toString(this.m_region));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startScenario() throws Exception {
        if (this.m_scenarioFile == null) {
            throw new Exception("No scenario file was given.");
        }
        if (this.m_scenarioDefinition == null) {
            throw new Exception(this.m_scenarioFile + " is an invalid scenario definition.");
        }
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(this.m_scenarioFile));
            StringBuffer buf = new StringBuffer();
            String s = null;
            while ((s = in.readLine()) != null) {
                buf.append(s);
            }
            this.report("startScenario begins..");
            this.m_scenarioInfo = m_simEngine.newScenario(this.m_serviceName, this.m_region, this.m_scenarioFile, "AutoTest", buf.toString(), null);
            this.report("startScenario OK on " + m_simEngineURL + ", GUID=" + this.m_scenarioInfo.id);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void getAnimationDP() throws Exception {
        if (this.m_animationDP != null) {
            return;
        }
        if (this.m_scenarioInfo == null) {
            throw new Exception("No scenario information is given.");
        }
        this.m_animationDP = new VWSIMAnimationDP(m_simEngine, this.m_scenarioInfo);
    }

    private void retrieveData() throws Exception {
        long startTime;
        this.getAnimationDP();
        long endTime = startTime = new Date().getTime() / 1000L;
        while (!this.m_animationDP.retrievalFinished()) {
            AutoTest.sleep(500L);
            endTime = new Date().getTime() / 1000L;
            if ((endTime - startTime) % 600L != 0L) continue;
            this.report("Still retrieving data..");
        }
        this.report("retrieveData OK -- Took: " + Long.toString(endTime - startTime) + " seconds.");
    }

    private String getInitialFileName() throws Exception {
        String name = this.m_scenarioInfo.name;
        int i = name.indexOf("::");
        if (i == -1) {
            return "NOTFOUND";
        }
        int j = name.indexOf("::", i + 2);
        if (j == -1) {
            j = name.length();
        }
        String res = name.substring(i + 2, j);
        File f = new File(res);
        this.report("Initial file = " + f.getCanonicalPath());
        return f.getName();
    }

    private void saveEventBuffer() throws Exception {
        this.getAnimationDP();
        while (!this.m_animationDP.retrievalFinished()) {
            AutoTest.sleep(500L);
        }
        String filename = this.m_scenarioInfo.id;
        if (this.m_outDir != null) {
            filename = this.m_outDir + "/" + this.getInitialFileName() + ".dat";
        }
        this.m_animationDP.writeToFiles(null, filename);
        this.report("saveEventBuffer OK to " + filename);
    }

    private void reportStatistics() throws Exception {
        this.getAnimationDP();
        IVWSIMEvent event = null;
        System.setProperty("filenet.sim.animationdp.reportfile", "stdout");
        while ((event = this.m_animationDP.getEvent()) != null && !event.finished()) {
        }
        String str = event.getStatistics().toString();
        this.report("Stats=" + str);
        this.report("DONE.");
    }

    private void statistics() throws Exception {
        this.report("NOW -- for the staticstics..");
    }

    private void analyzeInfo() throws Exception {
        int status = 0;
        do {
            status = m_simEngine.getScenarioPublisherStatus(this.m_scenarioInfo.id);
            AutoTest.sleep(500L);
        } while (status == 2);
        this.report("Done Publishing.");
        this.report(m_simEngine.getSimAnalyzerInfo(this.m_scenarioInfo.id));
    }

    public void run() {
        this.report("starting...");
        String methodCalled = null;
        try {
            if (this.m_scenarioInfo == null && this.m_scenarioFile != null) {
                methodCalled = "validateFile";
                this.validateFile();
                methodCalled = "startScenario";
                this.startScenario();
            }
            if (this.retrieveIt) {
                methodCalled = "retrieveData";
                this.retrieveData();
            }
            if (this.reportIt) {
                methodCalled = "reportStatistics";
                this.reportStatistics();
            }
            if (this.saveIt) {
                methodCalled = "saveEventBuffer";
                this.saveEventBuffer();
            }
            if (this.analyzeIt) {
                methodCalled = "analyzeInfo";
                this.analyzeInfo();
            }
            methodCalled = "statistics";
            this.statistics();
        }
        catch (Exception e) {
            this.report(methodCalled + " FAILED.." + e.getMessage());
            return;
        }
        this.report("done.");
    }

    private static String basicScenarioAsString(BasicScenario info) {
        StringBuffer buf = new StringBuffer(" SIMULATION: ");
        buf.append(info.id).append(", name:").append(info.name);
        return buf.toString();
    }

    public static void main(String[] args) {
        try {
            int i;
            VWCommandLineArgs c = new VWCommandLineArgs(args);
            String inputFile = c.getParameter("inputfile");
            if (inputFile != null) {
                c = new VWCommandLineArgs(inputFile, false);
            }
            String inDir = c.getParameter("indir", ".");
            String outDir = c.getParameter("outdir", ".");
            String server = c.getParameter("server", "localhost");
            String serverPort = c.getParameter("serverPort", "32771");
            boolean listIt = c.isPresent("list");
            boolean startIt = c.isPresent("start");
            boolean retrieveIt = c.isPresent("retrieve");
            boolean reportIt = c.isPresent("report");
            boolean saveIt = c.isPresent("save");
            boolean analyzeIt = c.isPresent("analyze");
            AutoTest.getSimEngine(server, serverPort);
            Thread[] workers = null;
            int nThreads = 0;
            if (listIt) {
                BasicScenario[] scenarios = m_simEngine.listScenarios();
                if (scenarios != null) {
                    nThreads = scenarios.length;
                    AutoTest.gReport("SIM ENGINE has " + Integer.toString(nThreads) + " Simulations.");
                    for (int j = 0; j < nThreads; ++j) {
                        AutoTest.gReport("[" + Integer.toString(j + 1) + "] " + AutoTest.basicScenarioAsString(scenarios[j]));
                    }
                    workers = new Thread[nThreads];
                    for (i = 0; i < nThreads; ++i) {
                        workers[i] = new AutoTest(i, scenarios[i], outDir, retrieveIt, reportIt, saveIt, analyzeIt);
                        workers[i].start();
                    }
                }
            } else if (startIt) {
                ArrayList files = AutoTest.getFiles(inDir);
                if (files == null) {
                    AutoTest.gReport("No files found.  EXIT");
                    System.exit(0);
                }
                if ((nThreads = files.size()) > 0) {
                    AutoTest.gReport("--------- FOUND " + files.size() + " FILES ------");
                    i = 0;
                    Iterator iter = files.iterator();
                    workers = new Thread[nThreads];
                    while (iter.hasNext()) {
                        File f = (File)iter.next();
                        workers[i] = new AutoTest(i, f.getCanonicalPath(), outDir, retrieveIt, reportIt, saveIt, analyzeIt);
                        workers[i].start();
                        ++i;
                    }
                }
            }
            while (--nThreads >= 0) {
                workers[nThreads].join();
                AutoTest.gReport(workers[nThreads] + " FINISHED..");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

